
// ICS_setup.js
//
//      Author:  Aaron Fischer (aaron.a.fischer@intel.com)
//     Created:  2004.10.08
// Description:  Expands the wa_setup.js API with additional methods for programmatically 
//               accessing a web page's metadata.

var pathObj = ParseURLPathName( location.pathname.toLowerCase() );
var metatagsObj = ParseMetatags();

// PasreURLPath()
//        input:  string - the URL path name of the web page in question
//       output:  object - pathObject { dir[], fullDir, fileName }
//  description:  parses the URL path into its component directories and file name.
//                e.g. "/a/b/foo.htm" becomes pathObject.dir[0] = "a", 
//			      pathObject.dir[1] = "b", pathObject.fullDir = "/a/b/", 
//				  pathObject.fileName = "foo.htm"
//
function ParseURLPathName(strURL)
{		
	var pathObject = new Object();
	pathObject.dir = new Array();

	// Assumed input string format:  
	// <URL_path><file_name> i.e. <dir1><dir2>...<dirN><file_name>
	//
	// /^             // match at beginning of string
	//   (.+?)        // non-greedily match and capture all.  Targets <dir1>
	//   (?:\/)+      // match zero or more "/" without capture
	//   (.*)         // greedily match all.  Targets <dir2>...<dirN><file_name>
	// /
	//
	// Note:  This is a much more complicated approach than strURL.split("/"),
	// but I thought it necessary for the rare case when multiple forward-slashes
	// are included in the URL path, e.g. a/b//c/d//foo.htm
	//
	i = 0;
	pathObject.fullDir = "/";
	strURL = strURL.replace(/^\//,"");  // Remove any beginning / in our URL
	while ((node = strURL.match(/^(.+?)(?:\/)+(.*)/)) && node[0].length)
	{
		pathObject.dir[i++] = node[1]; 					
		pathObject.fullDir += node[1] + "/";
		strURL = node[2];
	}
	pathObject.fileName = strURL;
	return pathObject;
}

// ParseMetatags()
//        input:  none
//       output:  associative array
//  description:  parses the document's HTML meta tags into an easily accessible hash
//
function ParseMetatags()
{		
	var metatagsObj = new Object;
	
	// 2005.02.03, Aaron Fischer:
	// This is hook code for IE5.x, whose Document Object Model doesn't support getElementsByTagName().
	// For now, we just extract the only meta tag we care about at the moment, "language".
	// This code will have to be expanded (or written for the general case of extracting all
	// meta tags) if additional meta tags will be referenced!
	//
	if (navigator.userAgent.match(/MSIE 5/)) {
		var m = new Array();
		var tempObj = new Object();
		if ((node = document.documentElement.innerHTML.match(
				/<meta\s+content\s*=\s*"?(.*?)"?\s+name\s*=\s*"?language"?\s*>/i))
		 || (node = document.documentElement.innerHTML.match(
				/<meta\s+content\s*=\s*"?(.*?)"?\s+name\s*=\s*"?language"?\s*>/i))
			) { 
			tempObj.name = "language";
			tempObj.content = node[1];
			m[0] = tempObj;	
		}			
	} else {
		var m = document.getElementsByTagName("meta");
	}
	
	for (i = 0; i < m.length; i++) {
		metatagsObj[m[i].name] = m[i].content;
	}
	return metatagsObj;
}